<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('members', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('reg_no');
            $table->string('profile_picture')->nullable();
            $table->string('interested_area')->nullable();
            $table->integer('age')->nullable();
            $table->string('gender');
            $table->string('address')->nullable();
            $table->string('phone')->nullable();
            $table->string('height')->nullable();
            $table->string('weight')->nullable();
            $table->string('status')->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('members');
    }
};